<?php

namespace PWCSD\NemesiCMS\Admin\Hosting\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DomainSubdomain extends Model 
{

    protected $table = 'domains_subdomains';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function databaseServer()
    {
        return $this->hasOne('Server', 'database_server_id');
    }

    public function domain()
    {
        return $this->belongsTo('Domain', 'domain_id');
    }

}